<?php
  include 'constants.php';
  $timeout = 5;
  spl_autoload_register('classLoader');
  session_start();

  try{
    $portal = new PortalFront("localhost", "php", "test", "testphp");
    if(!isset($_SESSION['statRecordId']) && 
       !$portal->zalogowany){  
      $_SESSION['statRecordId'] = $portal->addStatRecord(0);
    }
    
    $action = 'showMain';
    if (isset($_GET['action'])) {
      $action = $_GET['action'];
    }
    
    $komunikat = $portal->getMessage();
    $newsHeaders = $portal->getNewsHeaders(5);
    
    switch($action){
      case 'login' : 
        include 'login.php';
        break;
      case 'logout': 
        include 'logout.php';
        break;
      case 'saveSubscriptions';
        switch($portal->saveSubscriptions()){
          case ACTION_OK:
            $portal->setMessage("Dane zostały zapisane.");
            break;
          case SERVER_ERROR:
          default : 
            $portal->setMessage("Błąd serwera. Dane nie zostały zapisane.");
        }
        header('Location:index.php?action=showSubscriptions');
        break;
      default:
        include 'templates/mainTemplate.php';
    }
  }
  catch(Exception $e){
    echo 'Błąd: ' . $e->getMessage();
    exit('Portal chwilowo niedostępny');
  }
  
  
  function classLoader($nazwa){
    if(file_exists("klasy/$nazwa.php")){
      require_once("klasy/$nazwa.php");
    } else {
      throw new Exception("Brak pliku z definicją klasy.");
    }
  }  
?>
